IF EXISTS (SELECT * FROM sys.objects
		  WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_ORIGEM]')
			 AND type IN ( N'P', N'PC') )
    DROP PROCEDURE [dbo].[P_EST_PROD_ORIGEM];
GO
GO
--EXEC P_EST_PROD_ORIGEM 1
/*
Esta procedure roda dentro da P_EST_NF_ENT_DANFE_PROVISORIO_BLOQUEIO_PENDENTE_EXEC_ALL
*/

CREATE PROCEDURE P_EST_PROD_ORIGEM  @TIPO_PROC INT=0
WITH ENCRYPTION
AS
DECLARE @CD_EMP INT
DECLARE @CD_PROD INT
DECLARE @ORIGEMPRODUTO INT
DECLARE @DT_CAD DATETIME
DECLARE @DT_ATUAL DATETIME 
SET NOCOUNT ON;

PRINT '  Aplicando origem do produto no cadastro empresa  (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';

IF @TIPO_PROC=1
BEGIN
	SET @DT_ATUAL=CONVERT(CHAR(10),GETDATE()-200,112)
	DECLARE COrigemProduto CURSOR FAST_FORWARD FOR
	SELECT
		DISTINCT 
		EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_EMP,
		EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_PROD,
		EST_NF_ENT_DANFE_PROVISORIO_ITENS.ORIGEM,
		EST_NF_ENT_DANFE_PROVISORIO.DT_CAD
	FROM
		EST_NF_ENT_DANFE_PROVISORIO_ITENS INNER JOIN EST_PROD ON
		EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_EMP = EST_PROD.CD_EMP AND
		EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_PROD = EST_PROD.CD_PROD AND
		EST_NF_ENT_DANFE_PROVISORIO_ITENS.ORIGEM <> EST_PROD.ORIGEM_PRODUTO
		INNER JOIN EST_NF_ENT_DANFE_PROVISORIO ON
		EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO.CD_CTR  
	WHERE
		EST_NF_ENT_DANFE_PROVISORIO.DT_CAD >=@DT_ATUAL
	ORDER BY
		EST_NF_ENT_DANFE_PROVISORIO.DT_CAD
END

IF @TIPO_PROC=0
BEGIN
	DECLARE COrigemProduto CURSOR FAST_FORWARD FOR
	SELECT
		DISTINCT 
		EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_EMP,
		EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_PROD,
		EST_NF_ENT_DANFE_PROVISORIO_ITENS.ORIGEM,
		NULL
	FROM
		EST_NF_ENT_DANFE_PROVISORIO_ITENS INNER JOIN EST_PROD ON
		EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_EMP = EST_PROD.CD_EMP AND
		EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_PROD = EST_PROD.CD_PROD AND
		EST_NF_ENT_DANFE_PROVISORIO_ITENS.ORIGEM <> EST_PROD.ORIGEM_PRODUTO
		INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_PENDENTE ON
		EST_NF_ENT_DANFE_PROVISORIO_ITENS.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_PENDENTE.CD_CTR  	
END

OPEN COrigemProduto;
FETCH NEXT FROM COrigemProduto INTO @CD_EMP,
									@CD_PROD,
									@ORIGEMPRODUTO,
									@DT_CAD

WHILE @@FETCH_STATUS = 0
	BEGIN
		UPDATE
			P
		SET 
			P.ORIGEM_PRODUTO=@ORIGEMPRODUTO
		FROM
			EST_PROD P
		WHERE
			P.CD_EMP =@CD_EMP
			AND P.CD_PROD=@CD_PROD

	FETCH NEXT FROM COrigemProduto INTO @CD_EMP,
										@CD_PROD,
										@ORIGEMPRODUTO,
										@DT_CAD
	END;

CLOSE COrigemProduto;
DEALLOCATE COrigemProduto;